package ru.yandex.intranet.d.services.delivery.model

/**
 * Pre validated delivery destination.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class PreValidatedDeliveryDestination(
    val serviceId: Long,
    val quotaRequestId: Long,
    val resourceIds: List<String>
) {
    data class Builder(var serviceId: Long? = null,
                       var quotaRequestId: Long? = null,
                       val resourceIds: MutableList<String> = mutableListOf()
    ) {
        fun serviceId(serviceId: Long) = apply { this.serviceId = serviceId }
        fun quotaRequestId(quotaRequestId: Long) = apply { this.quotaRequestId = quotaRequestId }
        fun addResourceId(resourceId: String) = apply { this.resourceIds.add(resourceId) }
        fun addResourceIds(resourceIds: Collection<String>) = apply { this.resourceIds.addAll(resourceIds) }
        fun build() = PreValidatedDeliveryDestination(serviceId!!, quotaRequestId!!, resourceIds.toList())
    }
}
