package ru.yandex.intranet.d.services.delivery.model

/**
 * Pre validated delivery destination request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class PreValidatedDeliveryDestinationRequest(
    val userUid: String,
    val deliverables: List<PreValidatedDeliveryDestination>
) {
    data class Builder(var userUid: String? = null,
                       val deliverables: MutableList<PreValidatedDeliveryDestination> = mutableListOf()
    ) {
        fun userUid(userUid: String) = apply { this.userUid = userUid }
        fun addDeliverable(deliverable: PreValidatedDeliveryDestination) = apply { this.deliverables.add(deliverable) }
        fun addDeliverables(deliverables: Collection<PreValidatedDeliveryDestination>) =
            apply { this.deliverables.addAll(deliverables) }
        fun build() = PreValidatedDeliveryDestinationRequest(userUid!!, deliverables.toList())
    }
}
