package ru.yandex.intranet.d.services.delivery.model

import ru.yandex.intranet.d.model.resources.ResourceModel
import ru.yandex.intranet.d.model.services.ServiceMinimalModel

/**
 * Validated delivery destination.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class ValidatedDeliveryDestination(
    val service: ServiceMinimalModel,
    val quotaRequestId: Long,
    val resources: List<ResourceModel>
) {
    data class Builder(var service: ServiceMinimalModel? = null,
                       var quotaRequestId: Long? = null,
                       val resources: MutableList<ResourceModel> = mutableListOf()
    ) {
        fun service(service: ServiceMinimalModel) = apply { this.service = service }
        fun quotaRequestId(quotaRequestId: Long) = apply { this.quotaRequestId = quotaRequestId }
        fun addResource(resource: ResourceModel) = apply { this.resources.add(resource) }
        fun addResources(resources: Collection<ResourceModel>) = apply { this.resources.addAll(resources) }
        fun build() = ValidatedDeliveryDestination(service!!, quotaRequestId!!, resources.toList())
    }
}
