package ru.yandex.intranet.d.services.delivery.model

import ru.yandex.intranet.d.model.users.UserModel

/**
 * Validated delivery destination request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class ValidatedDeliveryDestinationRequest(
    val user: UserModel,
    val deliverables: List<ValidatedDeliveryDestination>
) {
    data class Builder(
        var user: UserModel? = null,
        val deliverables: MutableList<ValidatedDeliveryDestination> = mutableListOf()
    ) {

        fun user(user: UserModel) = apply { this.user = user }
        fun addDeliverable(deliverable: ValidatedDeliveryDestination) = apply { this.deliverables.add(deliverable) }
        fun addDeliverables(deliverables: Collection<ValidatedDeliveryDestination>) =
            apply { this.deliverables.addAll(deliverables) }
        fun build() = ValidatedDeliveryDestinationRequest(user!!, deliverables.toList())
    }
}
