package ru.yandex.intranet.d.services.delivery.model;

import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * Validated quotas.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ValidatedQuotas {

    private final Map<QuotaModel.Key, QuotaModel> originalQuotas;
    private final Map<QuotaModel.Key, QuotaModel> updatedQuotas;

    public ValidatedQuotas(Map<QuotaModel.Key, QuotaModel> originalQuotas,
                           Map<QuotaModel.Key, QuotaModel> updatedQuotas) {
        this.originalQuotas = originalQuotas;
        this.updatedQuotas = updatedQuotas;
    }

    public Map<QuotaModel.Key, QuotaModel> getOriginalQuotas() {
        return originalQuotas;
    }

    public Map<QuotaModel.Key, QuotaModel> getUpdatedQuotas() {
        return updatedQuotas;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedQuotas that = (ValidatedQuotas) o;
        return Objects.equals(originalQuotas, that.originalQuotas) &&
                Objects.equals(updatedQuotas, that.updatedQuotas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(originalQuotas, updatedQuotas);
    }

    @Override
    public String toString() {
        return "ValidatedQuotas{" +
                "originalQuotas=" + originalQuotas +
                ", updatedQuotas=" + updatedQuotas +
                '}';
    }

}
