package ru.yandex.intranet.d.services.delivery.model.provide

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import ru.yandex.intranet.d.services.delivery.model.DeliverableDelta
import ru.yandex.intranet.d.services.delivery.model.DeliverableMetaRequest

/**
 * Destination for delivery and provide operation
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryAndProvideDestination @JsonCreator constructor(
        val serviceId: Long,
        val providerId: String,
        val folderId: String,
        val accountId: String,
        val resourceId: String,
        val delta: DeliverableDelta,
        val meta: DeliverableMetaRequest
) {
    data class Builder(var serviceId: Long? = null,
                       var providerId: String? = null,
                       var folderId: String? = null,
                       var accountId: String? = null,
                       var resourceId: String? = null,
                       var delta: DeliverableDelta? = null,
                       var meta: DeliverableMetaRequest? = null
    ) {
        fun serviceId(serviceId: Long) = apply { this.serviceId = serviceId }
        fun providerId(providerId: String) = apply { this.providerId = providerId }
        fun folderId(folderId: String) = apply { this.folderId = folderId }
        fun accountId(accountId: String) = apply { this.accountId = accountId }
        fun resourceId(resourceId: String) = apply { this.resourceId = resourceId }
        fun delta(delta: DeliverableDelta) = apply { this.delta = delta }
        fun meta(meta: DeliverableMetaRequest) = apply { this.meta = meta }
        fun build() = DeliveryAndProvideDestination(serviceId!!, providerId!!, folderId!!, accountId!!, resourceId!!,
            delta!!, meta!!)
    }
}
