package ru.yandex.intranet.d.services.delivery.model.provide

/**
 * Request for delivery and provide operation
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
data class DeliveryAndProvideRequest(
    val deliveryId: String,
    val authorUid: String,
    val deliverables: List<DeliveryAndProvideDestination>
) {
    data class Builder(var deliveryId: String? = null,
                       var authorUid: String? = null,
                       val deliverables: MutableList<DeliveryAndProvideDestination> = mutableListOf()
    ) {
        fun deliveryId(deliveryId: String) = apply { this.deliveryId = deliveryId }
        fun authorUid(authorUid: String) = apply { this.authorUid = authorUid }
        fun addDeliverable(deliverable: DeliveryAndProvideDestination) = apply { this.deliverables.add(deliverable) }
        fun addDeliverables(deliverables: Collection<DeliveryAndProvideDestination>) =
            apply { this.deliverables.addAll(deliverables) }
        fun build() = DeliveryAndProvideRequest(deliveryId!!, authorUid!!, deliverables.toList())
    }
}
