package ru.yandex.intranet.d.services.delivery.model.provide

import ru.yandex.intranet.d.model.accounts.*
import ru.yandex.intranet.d.model.delivery.provide.DeliveryAndProvideModel
import ru.yandex.intranet.d.model.folders.FolderModel
import ru.yandex.intranet.d.model.providers.ProviderModel
import ru.yandex.intranet.d.model.resources.ResourceModel
import ru.yandex.intranet.d.model.resources.segmentations.ResourceSegmentationModel
import ru.yandex.intranet.d.model.resources.segments.ResourceSegmentModel
import ru.yandex.intranet.d.model.resources.types.ResourceTypeModel
import ru.yandex.intranet.d.model.services.ServiceWithStatesModel
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel
import ru.yandex.intranet.d.model.users.UserModel
import ru.yandex.intranet.d.services.operations.model.ExternalAccountsSpaceKey
import ru.yandex.intranet.d.services.operations.model.ExternalResourceKey

data class ProvideDictionary(
    val resourcesById: MutableMap<String, ResourceModel>,
    val resourceByExternalKey: MutableMap<ExternalResourceKey, ResourceModel>,
    val resourceTypesById: MutableMap<String, ResourceTypeModel>,
    val unitsEnsemblesById: MutableMap<String, UnitsEnsembleModel>,
    val foldersById: MutableMap<String, FolderModel>,
    val servicesById: MutableMap<Long, ServiceWithStatesModel>,
    val providersById: MutableMap<String, ProviderModel>,
    val author: UserModel,
    val accountsById: MutableMap<String, AccountModel>,
    val accountSpacesById: MutableMap<String, AccountSpaceModel>,
    val resourceSegmentationsById: MutableMap<String, ResourceSegmentationModel>,
    val resourceSegmentsById: MutableMap<String, ResourceSegmentModel>,
    val accountsQuotasOperationsByAccountId: MutableMap<String, AccountsQuotasOperationsModel>,
    val accountOpInProgressByAccountId: MutableMap<String, OperationInProgressModel>,
    val accountsSpaceByExternalKey: MutableMap<ExternalAccountsSpaceKey, AccountSpaceModel>,
    val deliveryRequestsModel: DeliveryAndProvideModel
)
