package ru.yandex.intranet.d.services.folders.history;

import java.time.Instant;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Provider continuation token.
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FolderHistoryContinuationToken {

    private final Instant dateTime;
    private final String id;

    @JsonCreator
    public FolderHistoryContinuationToken(@JsonProperty("dateTime") Instant dateTime,
                                          @JsonProperty("id") String id) {
        this.dateTime = dateTime;
        this.id = id;
    }

    public Instant getDateTime() {
        return dateTime;
    }

    public String getId() {
        return id;
    }

    @Override
    public String toString() {
        return "FolderHistoryContinuationToken{" +
                "dateTime=" + dateTime +
                ", id='" + id + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FolderHistoryContinuationToken that = (FolderHistoryContinuationToken) o;
        return Objects.equals(dateTime, that.dateTime) && Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(dateTime, id);
    }
}
