package ru.yandex.intranet.d.services.imports;

import java.util.Map;
import java.util.Optional;
import java.util.Set;

import ru.yandex.intranet.d.model.accounts.AccountsQuotasModel;
import ru.yandex.intranet.d.model.folders.FolderModel;
import ru.yandex.intranet.d.model.quotas.QuotaModel;
import ru.yandex.intranet.d.model.resources.ResourceModel;

/**
 * Account move info.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class AccountMoveInfo {

    private final FolderModel sourceFolder;
    private final FolderModel destinationFolder;
    private final String destinationFolderToCreateId;
    private final Set<ResourceModel> accountResources;
    private final Map<AccountsQuotasModel.Identity, AccountsQuotasModel> sourceProvisions;
    private final Map<AccountsQuotasModel.Identity, AccountsQuotasModel> destinationProvisions;
    private final Map<QuotaModel.Key, QuotaModel> sourceQuotas;
    private final Map<QuotaModel.Key, QuotaModel> destinationQuotas;
    private final String accountId;

    @SuppressWarnings("ParameterNumber")
    public AccountMoveInfo(FolderModel sourceFolder,
                           FolderModel destinationFolder,
                           String destinationFolderToCreateId,
                           Set<ResourceModel> accountResources,
                           Map<AccountsQuotasModel.Identity, AccountsQuotasModel> sourceProvisions,
                           Map<AccountsQuotasModel.Identity, AccountsQuotasModel> destinationProvisions,
                           Map<QuotaModel.Key, QuotaModel> sourceQuotas,
                           Map<QuotaModel.Key, QuotaModel> destinationQuotas,
                           String accountId) {
        this.sourceFolder = sourceFolder;
        this.destinationFolder = destinationFolder;
        this.destinationFolderToCreateId = destinationFolderToCreateId;
        this.accountResources = accountResources;
        this.sourceProvisions = sourceProvisions;
        this.destinationProvisions = destinationProvisions;
        this.sourceQuotas = sourceQuotas;
        this.destinationQuotas = destinationQuotas;
        this.accountId = accountId;
    }

    public FolderModel getSourceFolder() {
        return sourceFolder;
    }

    public Optional<FolderModel> getDestinationFolder() {
        return Optional.ofNullable(destinationFolder);
    }

    public Optional<String> getDestinationFolderToCreateId() {
        return Optional.ofNullable(destinationFolderToCreateId);
    }

    public Set<ResourceModel> getAccountResources() {
        return accountResources;
    }

    public Map<AccountsQuotasModel.Identity, AccountsQuotasModel> getSourceProvisions() {
        return sourceProvisions;
    }

    public Map<AccountsQuotasModel.Identity, AccountsQuotasModel> getDestinationProvisions() {
        return destinationProvisions;
    }

    public Map<QuotaModel.Key, QuotaModel> getSourceQuotas() {
        return sourceQuotas;
    }

    public Map<QuotaModel.Key, QuotaModel> getDestinationQuotas() {
        return destinationQuotas;
    }

    public String getAccountId() {
        return accountId;
    }

}
