package ru.yandex.intranet.d.services.imports;

import java.util.Map;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.folders.FolderModel;

/**
 * Accounts move info.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class AccountsMoveInfo {

    private final Map<AccountModel.ExternalId, AccountMoveInfo> movedAccounts;
    private final Map<String, FolderModel> foldersById;

    public AccountsMoveInfo(Map<AccountModel.ExternalId, AccountMoveInfo> movedAccounts,
                            Map<String, FolderModel> foldersById) {
        this.movedAccounts = movedAccounts;
        this.foldersById = foldersById;
    }

    public Map<AccountModel.ExternalId, AccountMoveInfo> getMovedAccounts() {
        return movedAccounts;
    }

    public Map<String, FolderModel> getFoldersById() {
        return foldersById;
    }

}
