package ru.yandex.intranet.d.services.imports;

import java.util.Objects;

/**
 * Folder, provider and resource ids.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class FolderProviderResource {

    private final String folderId;
    private final String providerId;
    private final String resourceId;

    public FolderProviderResource(String folderId, String providerId, String resourceId) {
        this.folderId = folderId;
        this.providerId = providerId;
        this.resourceId = resourceId;
    }

    public String getFolderId() {
        return folderId;
    }

    public String getProviderId() {
        return providerId;
    }

    public String getResourceId() {
        return resourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FolderProviderResource that = (FolderProviderResource) o;
        return Objects.equals(folderId, that.folderId) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(resourceId, that.resourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, providerId, resourceId);
    }

    @Override
    public String toString() {
        return "FolderProviderResource{" +
                "folderId='" + folderId + '\'' +
                ", providerId='" + providerId + '\'' +
                ", resourceId='" + resourceId + '\'' +
                '}';
    }

}
