package ru.yandex.intranet.d.services.imports;

import java.util.List;
import java.util.Optional;

/**
 * Import account.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ImportAccount {

    private final String id;
    private final String key;
    private final String displayName;
    private final boolean deleted;
    private final String providerId;
    private final List<ImportAccountProvision> provisions;
    private final AccountSpaceIdentity accountSpaceId;
    private final boolean freeTier;

    @SuppressWarnings("ParameterNumber")
    public ImportAccount(
            String id,
            String key,
            String displayName,
            boolean deleted,
            String providerId,
            List<ImportAccountProvision> provisions,
            AccountSpaceIdentity accountSpaceId,
            boolean freeTier
    ) {
        this.id = id;
        this.key = key;
        this.displayName = displayName;
        this.deleted = deleted;
        this.providerId = providerId;
        this.provisions = provisions;
        this.accountSpaceId = accountSpaceId;
        this.freeTier = freeTier;
    }

    public String getId() {
        return id;
    }

    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public boolean isDeleted() {
        return deleted;
    }

    public String getProviderId() {
        return providerId;
    }

    public List<ImportAccountProvision> getProvisions() {
        return provisions;
    }

    public AccountSpaceIdentity getAccountSpaceId() {
        return accountSpaceId;
    }

    public boolean isFreeTier() {
        return freeTier;
    }
}
