package ru.yandex.intranet.d.services.imports;

import java.util.Optional;

/**
 * Import account provision.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ImportAccountProvision {

    private final String resourceId;
    private final Long provided;
    private final String providedUnitKey;
    private final Long allocated;
    private final String allocatedUnitKey;
    private final String accountsSpaceId;

    public ImportAccountProvision(String resourceId, Long provided, String providedUnitKey, Long allocated,
                           String allocatedUnitKey, String accountsSpaceId) {
        this.resourceId = resourceId;
        this.provided = provided;
        this.providedUnitKey = providedUnitKey;
        this.allocated = allocated;
        this.allocatedUnitKey = allocatedUnitKey;
        this.accountsSpaceId = accountsSpaceId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public Long getProvided() {
        return provided;
    }

    public String getProvidedUnitKey() {
        return providedUnitKey;
    }

    public Long getAllocated() {
        return allocated;
    }

    public String getAllocatedUnitKey() {
        return allocatedUnitKey;
    }

    public Optional<String> getAccountsSpaceId() {
        return Optional.ofNullable(accountsSpaceId);
    }

}
