package ru.yandex.intranet.d.services.imports;

import java.util.Map;

import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * Import application.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ImportApplication {

    private final Map<QuotaModel.Key, QuotaImportApplication> quotas;
    private final Map<ProvisionImportKey, ProvisionImportApplication> provisions;

    public ImportApplication(Map<QuotaModel.Key, QuotaImportApplication> quotas,
                             Map<ProvisionImportKey, ProvisionImportApplication> provisions) {
        this.quotas = quotas;
        this.provisions = provisions;
    }

    public Map<QuotaModel.Key, QuotaImportApplication> getQuotas() {
        return quotas;
    }

    public Map<ProvisionImportKey, ProvisionImportApplication> getProvisions() {
        return provisions;
    }

}
