package ru.yandex.intranet.d.services.imports;

import java.util.List;
import java.util.Optional;

/**
 * Import folder.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ImportFolder {

    private final String folderId;
    private final Long serviceId;
    private final List<ImportResource> resourceQuotas;
    private final List<ImportAccount> accounts;

    public ImportFolder(String folderId, Long serviceId, List<ImportResource> resourceQuotas,
                 List<ImportAccount> accounts) {
        this.folderId = folderId;
        this.serviceId = serviceId;
        this.resourceQuotas = resourceQuotas;
        this.accounts = accounts;
    }

    public Optional<String> getFolderId() {
        return Optional.ofNullable(folderId);
    }

    public Optional<Long> getServiceId() {
        return Optional.ofNullable(serviceId);
    }

    public List<ImportResource> getResourceQuotas() {
        return resourceQuotas;
    }

    public List<ImportAccount> getAccounts() {
        return accounts;
    }

}
