package ru.yandex.intranet.d.services.imports;

import java.util.Optional;

/**
 * Import resource.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ImportResource {

    private final String resourceId;
    private final String providerId;
    private final long quota;
    private final String quotaUnitKey;
    private final long balance;
    private final String balanceUnitKey;
    private final String accountsSpaceId;

    public ImportResource(String resourceId, String providerId, long quota, String quotaUnitKey, long balance,
                   String balanceUnitKey, String accountsSpaceId) {
        this.resourceId = resourceId;
        this.providerId = providerId;
        this.quota = quota;
        this.quotaUnitKey = quotaUnitKey;
        this.balance = balance;
        this.balanceUnitKey = balanceUnitKey;
        this.accountsSpaceId = accountsSpaceId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public String getProviderId() {
        return providerId;
    }

    public long getQuota() {
        return quota;
    }

    public String getQuotaUnitKey() {
        return quotaUnitKey;
    }

    public long getBalance() {
        return balance;
    }

    public String getBalanceUnitKey() {
        return balanceUnitKey;
    }

    public Optional<String> getAccountsSpaceId() {
        return Optional.ofNullable(accountsSpaceId);
    }

}
