package ru.yandex.intranet.d.services.imports;

import java.util.Optional;

/**
 * Moving account.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class MovingAccount {

    private final String sourceFolderId;
    private final String destinationFolderId;
    private final String destinationFolderToCreateId;
    private final String accountId;

    public MovingAccount(String sourceFolderId, String destinationFolderId, String destinationFolderToCreateId,
                         String accountId) {
        this.sourceFolderId = sourceFolderId;
        this.destinationFolderId = destinationFolderId;
        this.destinationFolderToCreateId = destinationFolderToCreateId;
        this.accountId = accountId;
    }

    public String getSourceFolderId() {
        return sourceFolderId;
    }

    public Optional<String> getDestinationFolderId() {
        return Optional.ofNullable(destinationFolderId);
    }

    public Optional<String> getDestinationFolderToCreateId() {
        return Optional.ofNullable(destinationFolderToCreateId);
    }

    public String getAccountId() {
        return accountId;
    }

}
