package ru.yandex.intranet.d.services.imports;

import java.util.List;
import java.util.Map;

import ru.yandex.intranet.d.web.model.imports.ImportFailureDto;

/**
 * Prepared import data.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class PreparedImportData {

    private final List<ImportFolder> importedQuotas;
    private final List<ImportFailureDto> importFailures;
    private final Map<PreValidatedImport.AccountExternalId, String> preGeneratedAccountIds;
    private final Map<Long, String> preGeneratedFolderIds;
    private final ValidatedDirectories importDirectories;
    private final AccountsMoveInfo accountsMoveInfo;
    private final ImportApplication importApplication;
    private final Map<String, Integer> folderIndices;
    private final Map<Long, Integer> serviceIndices;

    @SuppressWarnings("ParameterNumber")
    public PreparedImportData(List<ImportFolder> importedQuotas,
                              List<ImportFailureDto> importFailures,
                              Map<PreValidatedImport.AccountExternalId, String> preGeneratedAccountIds,
                              Map<Long, String> preGeneratedFolderIds,
                              ValidatedDirectories importDirectories,
                              AccountsMoveInfo accountsMoveInfo,
                              ImportApplication importApplication,
                              Map<String, Integer> folderIndices,
                              Map<Long, Integer> serviceIndices) {
        this.importedQuotas = importedQuotas;
        this.importFailures = importFailures;
        this.preGeneratedAccountIds = preGeneratedAccountIds;
        this.preGeneratedFolderIds = preGeneratedFolderIds;
        this.importDirectories = importDirectories;
        this.accountsMoveInfo = accountsMoveInfo;
        this.importApplication = importApplication;
        this.folderIndices = folderIndices;
        this.serviceIndices = serviceIndices;
    }

    public List<ImportFolder> getImportedQuotas() {
        return importedQuotas;
    }

    public List<ImportFailureDto> getImportFailures() {
        return importFailures;
    }

    public Map<PreValidatedImport.AccountExternalId, String> getPreGeneratedAccountIds() {
        return preGeneratedAccountIds;
    }

    public Map<Long, String> getPreGeneratedFolderIds() {
        return preGeneratedFolderIds;
    }

    public ValidatedDirectories getImportDirectories() {
        return importDirectories;
    }

    public AccountsMoveInfo getAccountsMoveInfo() {
        return accountsMoveInfo;
    }

    public ImportApplication getImportApplication() {
        return importApplication;
    }

    public Map<String, Integer> getFolderIndices() {
        return folderIndices;
    }

    public Map<Long, Integer> getServiceIndices() {
        return serviceIndices;
    }

}
