package ru.yandex.intranet.d.services.imports;

import java.util.Objects;
import java.util.Optional;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.services.integration.providers.rest.model.ResourceComplexKey;

/**
 * Resource identity by provider id, {@link ResourceComplexKey} and {@link AccountSpaceIdentity}.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
public class ProviderWithResourceIdentity {

    private final String providerId;
    private final ResourceComplexKey resource;
    private final AccountSpaceIdentity accountSpace;

    public ProviderWithResourceIdentity(String providerId, ResourceComplexKey resource,
                                        AccountSpaceIdentity accountSpace) {
        this.providerId = providerId;
        this.resource = resource;
        this.accountSpace = accountSpace;
    }

    public String getProviderId() {
        return providerId;
    }

    public ResourceComplexKey getResource() {
        return resource;
    }

    public Optional<AccountSpaceIdentity> getAccountSpace() {
        return Optional.ofNullable(accountSpace);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProviderWithResourceIdentity that = (ProviderWithResourceIdentity) o;
        return Objects.equals(providerId, that.providerId) && Objects.equals(resource, that.resource)
                && Objects.equals(accountSpace, that.accountSpace);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providerId, resource, accountSpace);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
