package ru.yandex.intranet.d.services.imports;

import java.util.Optional;

/**
 * Provision import application.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ProvisionImportApplication {

    private final String accountId;
    private final String resourceId;
    private final String providerId;
    private final String folderId;
    private final Long originalProvidedQuota;
    private final Long originalAllocatedQuota;
    private final Long importedProvidedQuota;
    private final Long importedAllocatedQuota;
    private final boolean moveSource;
    private final String originalLatestSuccessfulProvisionOperationId;
    private final Long originalLastReceivedProvisionVersion;

    @SuppressWarnings("ParameterNumber")
    public ProvisionImportApplication(String accountId, String resourceId, String providerId,
                                      String folderId, Long originalProvidedQuota,
                                      Long originalAllocatedQuota, Long importedProvidedQuota,
                                      Long importedAllocatedQuota, boolean moveSource,
                                      String originalLatestSuccessfulProvisionOperationId,
                                      Long originalLastReceivedProvisionVersion) {
        this.accountId = accountId;
        this.resourceId = resourceId;
        this.providerId = providerId;
        this.folderId = folderId;
        this.originalProvidedQuota = originalProvidedQuota;
        this.originalAllocatedQuota = originalAllocatedQuota;
        this.importedProvidedQuota = importedProvidedQuota;
        this.importedAllocatedQuota = importedAllocatedQuota;
        this.moveSource = moveSource;
        this.originalLatestSuccessfulProvisionOperationId = originalLatestSuccessfulProvisionOperationId;
        this.originalLastReceivedProvisionVersion = originalLastReceivedProvisionVersion;
    }

    public String getAccountId() {
        return accountId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public String getProviderId() {
        return providerId;
    }

    public String getFolderId() {
        return folderId;
    }

    public Optional<Long> getOriginalProvidedQuota() {
        return Optional.ofNullable(originalProvidedQuota);
    }

    public Optional<Long> getOriginalAllocatedQuota() {
        return Optional.ofNullable(originalAllocatedQuota);
    }

    public Optional<Long> getImportedProvidedQuota() {
        return Optional.ofNullable(importedProvidedQuota);
    }

    public Optional<Long> getImportedAllocatedQuota() {
        return Optional.ofNullable(importedAllocatedQuota);
    }

    public boolean isMoveSource() {
        return moveSource;
    }

    public Optional<String> getOriginalLatestSuccessfulProvisionOperationId() {
        return Optional.ofNullable(originalLatestSuccessfulProvisionOperationId);
    }

    public Optional<Long> getOriginalLastReceivedProvisionVersion() {
        return Optional.ofNullable(originalLastReceivedProvisionVersion);
    }

    public boolean hasChanges() {
        if (originalAllocatedQuota == null && importedAllocatedQuota != null && importedAllocatedQuota > 0L) {
            // Added to new account
            return true;
        }
        if (originalAllocatedQuota != null && importedAllocatedQuota != null
                && !originalAllocatedQuota.equals(importedAllocatedQuota)) {
            // Allocated quota modified
            return true;
        }
        return hasProvidedChanges();
    }

    public boolean hasProvidedChanges() {
        if (originalProvidedQuota == null && importedProvidedQuota != null && importedProvidedQuota > 0L) {
            // Added to new account
            return true;
        }
        if (originalProvidedQuota != null && importedProvidedQuota != null
                && !originalProvidedQuota.equals(importedProvidedQuota)) {
            // Provided quota modified
            return true;
        }
        return false;
    }

}
