package ru.yandex.intranet.d.services.imports;

import java.util.Objects;

/**
 * Provision import key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ProvisionImportKey {

    private final String accountId;
    private final String resourceId;
    private final String folderId;

    public ProvisionImportKey(String accountId, String resourceId, String folderId) {
        this.accountId = accountId;
        this.resourceId = resourceId;
        this.folderId = folderId;
    }

    public String getAccountId() {
        return accountId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public String getFolderId() {
        return folderId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisionImportKey that = (ProvisionImportKey) o;
        return Objects.equals(accountId, that.accountId) &&
                Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(folderId, that.folderId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, resourceId, folderId);
    }

    @Override
    public String toString() {
        return "ProvisionImportKey{" +
                "accountId='" + accountId + '\'' +
                ", resourceId='" + resourceId + '\'' +
                ", folderId='" + folderId + '\'' +
                '}';
    }

}
