package ru.yandex.intranet.d.services.imports;

import java.math.BigDecimal;
import java.util.Optional;

/**
 * Quota import application.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class QuotaImportApplication {

    private final String folderId;
    private final String providerId;
    private final String resourceId;
    private final Long originalQuota;
    private final Long originalBalance;
    private final Long importedQuota;
    private final Long importedBalance;
    private BigDecimal actualBalance = BigDecimal.ZERO;

    @SuppressWarnings("ParameterNumber")
    public QuotaImportApplication(String folderId, String providerId, String resourceId, Long originalQuota,
                           Long originalBalance, Long importedQuota, Long importedBalance) {
        this.folderId = folderId;
        this.providerId = providerId;
        this.resourceId = resourceId;
        this.originalQuota = originalQuota;
        this.originalBalance = originalBalance;
        this.importedQuota = importedQuota;
        this.importedBalance = importedBalance;
    }

    public String getFolderId() {
        return folderId;
    }

    public String getProviderId() {
        return providerId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public Optional<Long> getOriginalQuota() {
        return Optional.ofNullable(originalQuota);
    }

    public Optional<Long> getOriginalBalance() {
        return Optional.ofNullable(originalBalance);
    }

    public Optional<Long> getImportedQuota() {
        return Optional.ofNullable(importedQuota);
    }

    public Optional<Long> getImportedBalance() {
        return Optional.ofNullable(importedBalance);
    }

    public BigDecimal getActualBalance() {
        return actualBalance;
    }

    public void setActualBalance(BigDecimal actualBalance) {
        this.actualBalance = actualBalance;
    }

    public boolean hasChanges() {
        return hasBalanceChanges() || hasQuotaChanges();
    }

    public boolean hasBalanceChanges() {
        BigDecimal originalBalanceDecimal = BigDecimal.valueOf(originalBalance != null ? originalBalance : 0L);
        if (originalBalance == null && actualBalance.compareTo(BigDecimal.ZERO) != 0) {
            // Zero balance to non-zero balance
            return true;
        }
        if (originalBalance != null && actualBalance.compareTo(originalBalanceDecimal) != 0) {
            // Updated balance
            return true;
        }
        return false;
    }

    public boolean hasQuotaChanges() {
        if (originalQuota == null && importedQuota != null && importedQuota > 0L) {
            // Zero quota to non-zero quota
            return true;
        }
        if (originalQuota != null && importedQuota != null && !originalQuota.equals(importedQuota)) {
            // Updated quota
            return true;
        }
        return false;
    }

}
