package ru.yandex.intranet.d.services.imports;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import ru.yandex.intranet.d.model.TenantId;
import ru.yandex.intranet.d.model.resources.ResourceSegmentSettingsModel;

/**
 * Resource identity by string id, set of segments, provider id and accounts space
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public final class ResourceIdentity {
    private final String resourceTypeId;
    private final TenantId tenantId;
    private final String accountSpaceId;
    private final Set<ResourceSegmentSettingsModel> segmentSettingsModels;
    private final String providerId;

    public ResourceIdentity(String resourceTypeId, TenantId tenantId, String accountSpaceId,
                               Set<ResourceSegmentSettingsModel> segmentSettingsModels, String providerId) {
        this.resourceTypeId = resourceTypeId;
        this.tenantId = tenantId;
        this.accountSpaceId = accountSpaceId;
        this.segmentSettingsModels = segmentSettingsModels;
        this.providerId = providerId;
    }

    public String getResourceTypeId() {
        return resourceTypeId;
    }

    public TenantId getTenantId() {
        return tenantId;
    }

    public Optional<String> getAccountSpaceId() {
        return Optional.ofNullable(accountSpaceId);
    }

    public Set<ResourceSegmentSettingsModel> getSegmentSettingsModels() {
        return segmentSettingsModels;
    }

    public String getProviderId() {
        return providerId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceIdentity that = (ResourceIdentity) o;
        return Objects.equals(resourceTypeId, that.resourceTypeId) &&
                Objects.equals(accountSpaceId, that.accountSpaceId) &&
                Objects.equals(segmentSettingsModels, that.segmentSettingsModels) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(tenantId, that.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeId, accountSpaceId, segmentSettingsModels, providerId, tenantId);
    }

    @Override
    public String toString() {
        return "ResourceIdentity{" +
                "resourceTypeId='" + resourceTypeId + '\'' +
                ", accountSpaceId='" + accountSpaceId + '\'' +
                ", segmentSettingsModels=" + segmentSettingsModels +
                ", providerId='" + providerId + '\'' +
                ", tenantId=" + tenantId +
                '}';
    }
}
