package ru.yandex.intranet.d.services.imports;

import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.resources.segmentations.ResourceSegmentationModel;
import ru.yandex.intranet.d.model.resources.segments.ResourceSegmentModel;

/**
 * SegmentationInfo.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 13.01.2021
 */
public final class SegmentationInfo {
    private final ResourceSegmentationModel segmentationModel;
    private final Map<String, ResourceSegmentModel> segmentsByKey;

    public SegmentationInfo(
            ResourceSegmentationModel segmentationModel,
            Map<String, ResourceSegmentModel> segmentsByKey
    ) {
        this.segmentationModel = segmentationModel;
        this.segmentsByKey = segmentsByKey;
    }

    public ResourceSegmentationModel getSegmentationModel() {
        return segmentationModel;
    }

    public Map<String, ResourceSegmentModel> getSegmentsByKey() {
        return segmentsByKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SegmentationInfo that = (SegmentationInfo) o;
        return Objects.equals(segmentationModel, that.segmentationModel) && Objects.equals(segmentsByKey,
                that.segmentsByKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentationModel, segmentsByKey);
    }

    @Override
    public String toString() {
        return "SegmentationInfo{" +
                "segmentationModel=" + segmentationModel +
                ", segmentsByKey=" + segmentsByKey +
                '}';
    }
}
