package ru.yandex.intranet.d.services.imports;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.accounts.AccountSpaceModel;
import ru.yandex.intranet.d.model.folders.FolderModel;
import ru.yandex.intranet.d.model.providers.ProviderModel;
import ru.yandex.intranet.d.model.resources.ResourceModel;
import ru.yandex.intranet.d.model.resources.segmentations.ResourceSegmentationModel;
import ru.yandex.intranet.d.model.services.ServiceWithStatesModel;
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel;
import ru.yandex.intranet.d.services.integration.providers.rest.model.ResourceComplexKey;

/**
 * Validated directories.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ValidatedDirectories {

    private final Map<String, ProviderModel> providers;
    private final Map<AccountSpaceIdentity, AccountSpaceModel> accountSpaces;
    private final Map<ResourceComplexKey, ResourceModel> resourcesByComplexKey;
    private final Map<String, ResourceModel> resources;
    private final Map<PreValidatedImport.AccountExternalId, AccountModel> accounts;
    private final Map<AccountModel.ExternalId, AccountModel> accountsByExternalId;
    private final Map<String, FolderModel> folders;
    private final Map<Long, ServiceWithStatesModel> services;
    private final Map<String, UnitsEnsembleModel> unitsEnsembles;
    private final Map<Long, FolderModel> defaultFolders;
    private final Map<ResourceSegmentationModel.ProviderKey, SegmentationInfo> segmentations;

    @SuppressWarnings("ParameterNumber")
    public ValidatedDirectories(
            Map<String, ProviderModel> providers,
            Map<AccountSpaceIdentity, AccountSpaceModel> accountSpaces,
            Map<ResourceComplexKey, ResourceModel> resourcesByComplexKey,
            Map<String, ResourceModel> resources,
            Map<PreValidatedImport.AccountExternalId, AccountModel> accounts,
            Map<String, FolderModel> folders, Map<Long, ServiceWithStatesModel> services,
            Map<String, UnitsEnsembleModel> unitsEnsembles,
            Map<Long, FolderModel> defaultFolders,
            Map<ResourceSegmentationModel.ProviderKey, SegmentationInfo> segmentations
    ) {
        this.providers = providers;
        this.accountSpaces = accountSpaces;
        this.resources = resources;
        this.resourcesByComplexKey = resourcesByComplexKey;
        this.accounts = accounts;
        this.accountsByExternalId = accounts.values().stream().collect(
                Collectors.toMap(AccountModel::toExternalId, Function.identity()));
        this.folders = folders;
        this.services = services;
        this.unitsEnsembles = unitsEnsembles;
        this.defaultFolders = defaultFolders;
        this.segmentations = segmentations;
    }

    public Map<String, ProviderModel> getProviders() {
        return providers;
    }

    public Map<ResourceComplexKey, ResourceModel> getResourcesByComplexKey() {
        return resourcesByComplexKey;
    }

    public Map<String, ResourceModel> getResources() {
        return resources;
    }

    public Map<PreValidatedImport.AccountExternalId, AccountModel> getAccounts() {
        return accounts;
    }

    public Map<AccountModel.ExternalId, AccountModel> getAccountsByExternalId() {
        return accountsByExternalId;
    }

    public Map<String, FolderModel> getFolders() {
        return folders;
    }

    public Map<Long, ServiceWithStatesModel> getServices() {
        return services;
    }

    public Map<String, UnitsEnsembleModel> getUnitsEnsembles() {
        return unitsEnsembles;
    }

    public Map<Long, FolderModel> getDefaultFolders() {
        return defaultFolders;
    }

    public Map<AccountSpaceIdentity, AccountSpaceModel> getAccountSpaces() {
        return accountSpaces;
    }

    public Map<ResourceSegmentationModel.ProviderKey, SegmentationInfo> getSegmentations() {
        return segmentations;
    }
}
