package ru.yandex.intranet.d.services.imports;

import java.util.List;
import java.util.Map;

import ru.yandex.intranet.d.web.model.imports.ImportFailureDto;

/**
 * Validated import.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ValidatedImport {
    private final ValidatedDirectories directories;
    private final List<ImportFailureDto> failures;
    private final List<ImportFolder> quotas;
    private final Map<PreValidatedImport.AccountExternalId, String> preGeneratedAccountIds;
    private final Map<Long, String> preGeneratedFolderIds;
    private final Map<String, Integer> folderIndices;
    private final Map<Long, Integer> serviceIndices;

    public ValidatedImport(ValidatedDirectories directories,
                           List<ImportFailureDto> failures,
                           List<ImportFolder> quotas,
                           Map<PreValidatedImport.AccountExternalId, String> preGeneratedAccountIds,
                           Map<Long, String> preGeneratedFolderIds,
                           Map<String, Integer> folderIndices,
                           Map<Long, Integer> serviceIndices) {
        this.directories = directories;
        this.failures = failures;
        this.quotas = quotas;
        this.preGeneratedAccountIds = preGeneratedAccountIds;
        this.preGeneratedFolderIds = preGeneratedFolderIds;
        this.folderIndices = folderIndices;
        this.serviceIndices = serviceIndices;
    }

    public ValidatedDirectories getDirectories() {
        return directories;
    }

    public List<ImportFailureDto> getFailures() {
        return failures;
    }

    public List<ImportFolder> getQuotas() {
        return quotas;
    }

    public Map<PreValidatedImport.AccountExternalId, String> getPreGeneratedAccountIds() {
        return preGeneratedAccountIds;
    }

    public Map<Long, String> getPreGeneratedFolderIds() {
        return preGeneratedFolderIds;
    }

    public Map<String, Integer> getFolderIndices() {
        return folderIndices;
    }

    public Map<Long, Integer> getServiceIndices() {
        return serviceIndices;
    }

}
