package ru.yandex.intranet.d.services.imports;

import java.util.Map;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.accounts.AccountsQuotasModel;
import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * Validated import with quotas.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class ValidatedImportWithQuotas {

    private final ValidatedImport validatedImport;
    private final Map<QuotaModel.Key, QuotaModel> quotas;
    private final Map<AccountsQuotasModel.Identity, AccountsQuotasModel> provisions;
    private final Map<String, AccountModel> accounts;

    public ValidatedImportWithQuotas(ValidatedImport validatedImport, Map<QuotaModel.Key, QuotaModel> quotas,
                              Map<AccountsQuotasModel.Identity, AccountsQuotasModel> provisions,
                              Map<String, AccountModel> accounts) {
        this.validatedImport = validatedImport;
        this.quotas = quotas;
        this.provisions = provisions;
        this.accounts = accounts;
    }

    public ValidatedImport getValidatedImport() {
        return validatedImport;
    }

    public Map<QuotaModel.Key, QuotaModel> getQuotas() {
        return quotas;
    }

    public Map<AccountsQuotasModel.Identity, AccountsQuotasModel> getProvisions() {
        return provisions;
    }

    public Map<String, AccountModel> getAccounts() {
        return accounts;
    }

}
