package ru.yandex.intranet.d.services.integration.jns

import mu.KotlinLogging
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Component
import java.util.concurrent.atomic.AtomicLong

private val logger = KotlinLogging.logger {}

/**
 * Jns client stub.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
@Profile("local", "load-testing", "integration-tests", "test-recipe")
class JnsClientStub: JnsClient {

    private val counter: AtomicLong = AtomicLong(0)

    override suspend fun send(message: JnsMessage): JnsResult {
        logger.info { "Message $message for JNS" }
        counter.incrementAndGet()
        return JnsResult.success()
    }

    fun getCounter(): Long {
        return counter.get()
    }
}
