package ru.yandex.intranet.d.services.integration.jns

/**
 * Jns result.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
sealed interface JnsResult {
    data class Success(private val dummy: Unit = Unit): JnsResult
    data class Failure(val error: Throwable): JnsResult
    data class Error(val statusCode: Int, val errorObject: JnsResponse?, val errorText: String?): JnsResult
    companion object {
        @JvmStatic
        fun success(): JnsResult = Success()
        @JvmStatic
        fun failure(error: Throwable): JnsResult = Failure(error)
        @JvmStatic
        fun error(statusCode: Int, errorObject: JnsResponse?, errorText: String?): JnsResult
                = Error(statusCode, errorObject, errorText)
    }
}
