package ru.yandex.intranet.d.services.integration.providers;

import java.util.concurrent.ConcurrentHashMap;

import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Provider integration metrics.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
public class IntegrationMetrics {

    private static final String RATE = "provider.requests.rate";
    private static final String DURATION = "provider.requests.duration_millis";
    private static final String RESULT = "provider_result";
    private static final String ANY = "any";
    private static final String FAILURE = "failure";
    private static final String OP = "provider_op";
    private static final String PROVIDER = "provider";
    private static final String UPDATE_PROVISION = "update_provision";
    private static final String GET_ACCOUNT = "get_account";
    private static final String CREATE_ACCOUNT = "create_account";
    private static final String CREATE_ACCOUNT_AND_PROVIDE = "create_account_and_provide";
    private static final String DELETE_ACCOUNT = "delete_account";
    private static final String RENAME_ACCOUNT = "rename_account";
    private static final String MOVE_ACCOUNT = "move_account";
    private static final String MOVE_PROVISION = "move_provision";
    private static final String LIST_ACCOUNTS = "list_accounts";
    private static final String LIST_ACCOUNTS_BY_FOLDER = "list_accounts_by_folder";
    private static final String REVOKE_FREE_TIER = "revoke_free_tier";

    private final ConcurrentHashMap<String, Rate> updateProvisionRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> updateProvisionErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> updateProvisionDuration = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> getAccountRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> getAccountErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> getAccountDuration = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> createAccountRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> createAccountErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> createAccountDuration = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> createAccountAndProvideRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> createAccountAndProvideErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> createAccountAndProvideDuration = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> deleteAccountRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> deleteAccountErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> deleteAccountDuration = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> renameAccountRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> renameAccountErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> renameAccountDuration = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> moveAccountRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> moveAccountErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> moveAccountDuration = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> moveProvisionRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> moveProvisionErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> moveProvisionDuration = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> listAccountsRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> listAccountsErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> listAccountsDuration = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> listAccountsByFolderRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> listAccountsByFolderErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> listAccountsByFolderDuration = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> revokeFreeTierRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Rate> revokeFreeTierErrorRate = new ConcurrentHashMap<>();
    private final ConcurrentHashMap<String, Histogram> revokeFreeTierDuration = new ConcurrentHashMap<>();

    public void afterUpdateProvision(String providerKey, long durationMillis, boolean success) {
        updateProvisionRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, UPDATE_PROVISION, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            updateProvisionErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, UPDATE_PROVISION, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        updateProvisionDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, UPDATE_PROVISION, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

    public void afterGetAccount(String providerKey, long durationMillis, boolean success) {
        getAccountRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, GET_ACCOUNT, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            getAccountErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, GET_ACCOUNT, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        getAccountDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, GET_ACCOUNT, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

    public void afterCreateAccount(String providerKey, long durationMillis, boolean success) {
        createAccountRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, CREATE_ACCOUNT, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            createAccountErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, CREATE_ACCOUNT, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        createAccountDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, CREATE_ACCOUNT, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

    public void afterCreateAccountAndProvide(String providerKey, long durationMillis, boolean success) {
        createAccountAndProvideRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, CREATE_ACCOUNT_AND_PROVIDE, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            createAccountAndProvideErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, CREATE_ACCOUNT_AND_PROVIDE, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        createAccountAndProvideDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, CREATE_ACCOUNT_AND_PROVIDE, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

    public void afterDeleteAccount(String providerKey, long durationMillis, boolean success) {
        deleteAccountRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, DELETE_ACCOUNT, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            deleteAccountErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, DELETE_ACCOUNT, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        deleteAccountDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, DELETE_ACCOUNT, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

    public void afterRenameAccount(String providerKey, long durationMillis, boolean success) {
        renameAccountRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, RENAME_ACCOUNT, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            renameAccountErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, RENAME_ACCOUNT, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        renameAccountDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, RENAME_ACCOUNT, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

    public void afterMoveAccount(String providerKey, long durationMillis, boolean success) {
        moveAccountRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, MOVE_ACCOUNT, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            moveAccountErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, MOVE_ACCOUNT, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        moveAccountDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, MOVE_ACCOUNT, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

    public void afterMoveProvision(String providerKey, long durationMillis, boolean success) {
        moveProvisionRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, MOVE_PROVISION, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            moveProvisionErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, MOVE_PROVISION, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        moveProvisionDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, MOVE_PROVISION, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

    public void afterListAccounts(String providerKey, long durationMillis, boolean success) {
        listAccountsRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, LIST_ACCOUNTS, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            listAccountsErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, LIST_ACCOUNTS, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        listAccountsDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, LIST_ACCOUNTS, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

    public void afterListAccountsByFolder(String providerKey, long durationMillis, boolean success) {
        listAccountsByFolderRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, LIST_ACCOUNTS_BY_FOLDER, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            listAccountsByFolderErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, LIST_ACCOUNTS_BY_FOLDER, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        listAccountsByFolderDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, LIST_ACCOUNTS_BY_FOLDER, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

    public void afterRevokeFreeTier(String providerKey, long durationMillis, boolean success) {
        revokeFreeTierRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                .rate(RATE, Labels.of(OP, REVOKE_FREE_TIER, RESULT, ANY, PROVIDER, k))).inc();
        if (!success) {
            revokeFreeTierErrorRate.computeIfAbsent(providerKey, k -> MetricRegistry.root()
                    .rate(RATE, Labels.of(OP, REVOKE_FREE_TIER, RESULT, FAILURE, PROVIDER, k))).inc();
        }
        revokeFreeTierDuration.computeIfAbsent(providerKey, k -> MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, REVOKE_FREE_TIER, PROVIDER, k), Histograms.exponential(22, 2.0d, 1.0d)))
                .record(durationMillis);
    }

}
