package ru.yandex.intranet.d.services.integration.providers;

import java.util.UUID;
import java.util.function.Supplier;

/**
 * RequestIdSupplier.
 * Supplier айдишников, у которого можно запросить последний отданный id.
 * Нужен чтобы при логировании достать requestId который был использован в очередном ретрае.
 *
 * @author Petr Surkov <petrsurkov@yandex-team.ru>
 */
public class RequestIdSupplier implements Supplier<String> {
    private volatile String lastId;

    @Override
    public String get() {
        return lastId = UUID.randomUUID().toString();
    }

    public String getLastId() {
        return lastId;
    }
}
