package ru.yandex.intranet.d.services.integration.providers.grpc;

import java.util.concurrent.Executor;

import io.grpc.CallCredentials;
import io.grpc.Metadata;

/**
 * Adds dummy credentials for GRPC auth.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class DummyCallCredentials extends CallCredentials {

    private static final Metadata.Key<String> AUTH_HEADER_HEY = Metadata.Key.of("X-Ya-Service-Id",
            Metadata.ASCII_STRING_MARSHALLER);

    private final long tvmClientId;

    public DummyCallCredentials(long tvmClientId) {
        this.tvmClientId = tvmClientId;
    }

    @Override
    public void applyRequestMetadata(RequestInfo requestInfo, Executor appExecutor, MetadataApplier applier) {
        Metadata authHeaders = new Metadata();
            authHeaders.put(AUTH_HEADER_HEY, String.valueOf(tvmClientId));
        applier.apply(authHeaders);
    }

    @Override
    public void thisUsesUnstableApi() {
    }

}
