package ru.yandex.intranet.d.services.integration.providers.grpc;

import java.util.concurrent.Executor;

import io.grpc.CallCredentials;
import io.grpc.Metadata;

/**
 * Adds no credentials for GRPC auth.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class EmptyCallCredentials extends CallCredentials {

    @Override
    public void applyRequestMetadata(RequestInfo requestInfo, Executor appExecutor, MetadataApplier applier) {
        Metadata authHeaders = new Metadata();
        applier.apply(authHeaders);
    }

    @Override
    public void thisUsesUnstableApi() {
    }

}
