package ru.yandex.intranet.d.services.integration.providers.grpc;

import io.grpc.ManagedChannelBuilder;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

/**
 * GRPC channel builder supplier stub.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
@Profile({"dev", "testing", "production", "load-testing", "local", "test-recipe"})
public class GrpcChannelBuilderSupplierImpl implements GrpcChannelBuilderSupplier {

    @Override
    @SuppressWarnings("unchecked")
    public ManagedChannelBuilder<?> get(String name) {
        return ManagedChannelBuilder.forTarget(name);
    }

}
