package ru.yandex.intranet.d.services.integration.providers.grpc;

import java.net.URI;

import io.grpc.inprocess.InProcessChannelBuilder;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

/**
 * GRPC channel builder supplier stub.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
@Profile({"integration-tests"})
public class GrpcChannelBuilderSupplierStub implements GrpcChannelBuilderSupplier {

    @Override
    @SuppressWarnings("unchecked")
    public InProcessChannelBuilder get(String name) {
        // in-process:test is expected as name here
        URI address = URI.create(name);
        if (!"in-process".equals(address.getScheme())) {
            throw new IllegalArgumentException("Unsupported channel name: " + name);
        }
        return InProcessChannelBuilder.forName(address.getSchemeSpecificPart());
    }

}
