package ru.yandex.intranet.d.services.integration.providers.grpc;

import java.util.function.BiConsumer;
import java.util.function.Function;

import com.salesforce.reactorgrpc.stub.ClientCalls;
import io.grpc.CallOptions;
import io.grpc.stub.StreamObserver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * Reactive GRPC client helpers.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public final class GrpcClient {

    private GrpcClient() {
    }

    public static <TRequest, TResponse> Mono<TResponse> oneToOne(
            Mono<TRequest> monoSource, BiConsumer<TRequest, StreamObserver<TResponse>> delegate, CallOptions options) {
        return ClientCalls.oneToOne(monoSource, delegate, options);
    }

    public static <TRequest, TResponse> Flux<TResponse> oneToMany(
            Mono<TRequest> monoSource, BiConsumer<TRequest, StreamObserver<TResponse>> delegate, CallOptions options) {
        return ClientCalls.oneToMany(monoSource, delegate, options);
    }

    public static <TRequest, TResponse> Mono<TResponse> manyToOne(
            Flux<TRequest> fluxSource,
            Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate,
            CallOptions options) {
        return ClientCalls.manyToOne(fluxSource, delegate, options);
    }

    public static <TRequest, TResponse> Flux<TResponse> manyToMany(
            Flux<TRequest> fluxSource,
            Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate,
            CallOptions options) {
        return ClientCalls.manyToMany(fluxSource, delegate, options);
    }

}
