package ru.yandex.intranet.d.services.integration.providers.grpc;

import java.util.concurrent.Executor;

import io.grpc.CallCredentials;
import io.grpc.Metadata;

/**
 * Adds TVM ticket for GRPC auth.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class TvmCallCredentials extends CallCredentials {

    public static final Metadata.Key<String> TVM_SERVICE_TICKET_KEY = Metadata.Key
            .of("X-Ya-Service-Ticket", Metadata.ASCII_STRING_MARSHALLER);
    private final String tvmTicket;

    public TvmCallCredentials(String tvmTicket) {
        this.tvmTicket = tvmTicket;
    }

    @Override
    public void applyRequestMetadata(RequestInfo requestInfo, Executor appExecutor, MetadataApplier applier) {
        Metadata authHeaders = new Metadata();
        authHeaders.put(TVM_SERVICE_TICKET_KEY, tvmTicket);
        applier.apply(authHeaders);
    }

    @Override
    public void thisUsesUnstableApi() {
    }

}
