package ru.yandex.intranet.d.services.integration.providers.rest;

import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

/**
 * Provider API authentication supplier implementation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
@Profile({"dev", "testing", "production", "load-testing", "local", "integration-tests"})
public class RestCallCredentialsSupplierImpl implements RestCallCredentialsSupplier {

    @Override
    public WebClient.RequestBodySpec supplyCredentials(WebClient.RequestBodySpec spec, String serviceTicket) {
        return spec.header("X-Ya-Service-Ticket", serviceTicket);
    }

}
