package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Account.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class AccountDto {

    private final String accountId;
    private final String key;
    private final String displayName;
    private final String folderId;
    private final Boolean deleted;
    private final List<ProvisionDto> provisions;
    private final Long accountVersion;
    private final AccountsSpaceKeyResponseDto accountsSpaceKey;
    private final LastUpdateDto lastUpdate;
    private final Boolean freeTier;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public AccountDto(@JsonProperty("accountId") String accountId,
                      @JsonProperty("key") String key,
                      @JsonProperty("displayName") String displayName,
                      @JsonProperty("folderId") String folderId,
                      @JsonProperty("deleted") Boolean deleted,
                      @JsonProperty("provisions") List<ProvisionDto> provisions,
                      @JsonProperty("accountVersion") Long accountVersion,
                      @JsonProperty("accountsSpaceKey") AccountsSpaceKeyResponseDto accountsSpaceKey,
                      @JsonProperty("lastUpdate") LastUpdateDto lastUpdate,
                      @JsonProperty("freeTier") boolean freeTier
    ) {
        this.accountId = accountId;
        this.key = key;
        this.displayName = displayName;
        this.folderId = folderId;
        this.deleted = deleted;
        this.provisions = provisions;
        this.accountVersion = accountVersion;
        this.accountsSpaceKey = accountsSpaceKey;
        this.lastUpdate = lastUpdate;
        this.freeTier = freeTier;
    }

    public Optional<String> getAccountId() {
        return Optional.ofNullable(accountId);
    }

    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Optional<String> getFolderId() {
        return Optional.ofNullable(folderId);
    }

    public Optional<Boolean> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    public Optional<List<ProvisionDto>> getProvisions() {
        return Optional.ofNullable(provisions);
    }

    public Optional<Long> getAccountVersion() {
        return Optional.ofNullable(accountVersion);
    }

    public Optional<AccountsSpaceKeyResponseDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    public Optional<LastUpdateDto> getLastUpdate() {
        return Optional.ofNullable(lastUpdate);
    }

    @JsonProperty("freeTier")
    public Optional<Boolean> isFreeTier() {
        return Optional.ofNullable(freeTier);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountDto that = (AccountDto) o;
        return Objects.equals(accountId, that.accountId) &&
                Objects.equals(key, that.key) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(deleted, that.deleted) &&
                Objects.equals(provisions, that.provisions) &&
                Objects.equals(accountVersion, that.accountVersion) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey) &&
                Objects.equals(lastUpdate, that.lastUpdate) &&
                Objects.equals(freeTier, that.freeTier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, key, displayName, folderId, deleted, provisions, accountVersion,
                accountsSpaceKey, lastUpdate, freeTier);
    }

    @Override
    public String toString() {
        return "AccountDto{" +
                "accountId='" + accountId + '\'' +
                ", key='" + key + '\'' +
                ", displayName='" + displayName + '\'' +
                ", folderId='" + folderId + '\'' +
                ", deleted=" + deleted +
                ", provisions=" + provisions +
                ", accountVersion=" + accountVersion +
                ", accountsSpaceKey=" + accountsSpaceKey +
                ", lastUpdate=" + lastUpdate +
                ", freeTier=" + freeTier +
                '}';
    }

}
