package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Accounts space key request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountsSpaceKeyRequestDto {

    private final List<SegmentKeyRequestDto> segmentation;

    @JsonCreator
    public AccountsSpaceKeyRequestDto(@JsonProperty("segmentation") List<SegmentKeyRequestDto> segmentation) {
        this.segmentation = segmentation;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<List<SegmentKeyRequestDto>> getSegmentation() {
        return Optional.ofNullable(segmentation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsSpaceKeyRequestDto that = (AccountsSpaceKeyRequestDto) o;
        return Objects.equals(segmentation, that.segmentation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentation);
    }

    @Override
    public String toString() {
        return "AccountsSpaceKeyRequestDto{" +
                "segmentation=" + segmentation +
                '}';
    }

}
