package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Accounts space key response.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountsSpaceKeyResponseDto {

    private final List<SegmentKeyResponseDto> segmentation;

    @JsonCreator
    public AccountsSpaceKeyResponseDto(@JsonProperty("segmentation") List<SegmentKeyResponseDto> segmentation) {
        this.segmentation = segmentation;
    }

    public Optional<List<SegmentKeyResponseDto>> getSegmentation() {
        return Optional.ofNullable(segmentation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsSpaceKeyResponseDto that = (AccountsSpaceKeyResponseDto) o;
        return Objects.equals(segmentation, that.segmentation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentation);
    }

    @Override
    public String toString() {
        return "AccountsSpaceKeyResponseDto{" +
                "segmentation=" + segmentation +
                '}';
    }

}
