package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Create account and provide request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class CreateAccountAndProvideRequestDto {

    private final String key;
    private final String displayName;
    private final String folderId;
    private final long abcServiceId;
    private final List<ProvisionRequestDto> provisions;
    private final List<KnownAccountProvisionsDto> knownProvisions;
    private final UserIdDto author;
    private final String operationId;
    private final AccountsSpaceKeyRequestDto accountsSpaceKey;
    private final Boolean freeTier;
    private final String abcServiceSlug;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public CreateAccountAndProvideRequestDto(
            @JsonProperty("key") String key,
            @JsonProperty("displayName") String displayName,
            @JsonProperty("folderId") String folderId,
            @JsonProperty("abcServiceId") long abcServiceId,
            @JsonProperty("provisions") List<ProvisionRequestDto> provisions,
            @JsonProperty("knownProvisions") List<KnownAccountProvisionsDto> knownProvisions,
            @JsonProperty("author") UserIdDto author,
            @JsonProperty("operationId") String operationId,
            @JsonProperty("accountsSpaceKey") AccountsSpaceKeyRequestDto accountsSpaceKey,
            @JsonProperty("freeTier") Boolean freeTier,
            @JsonProperty("abcServiceSlug") String abcServiceSlug
    ) {
        this.key = key;
        this.displayName = displayName;
        this.folderId = folderId;
        this.abcServiceId = abcServiceId;
        this.provisions = provisions;
        this.knownProvisions = knownProvisions;
        this.author = author;
        this.operationId = operationId;
        this.accountsSpaceKey = accountsSpaceKey;
        this.freeTier = freeTier;
        this.abcServiceSlug = abcServiceSlug;
    }

    public String getKey() {
        return key;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getFolderId() {
        return folderId;
    }

    public long getAbcServiceId() {
        return abcServiceId;
    }

    public List<ProvisionRequestDto> getProvisions() {
        return provisions;
    }

    public List<KnownAccountProvisionsDto> getKnownProvisions() {
        return knownProvisions;
    }

    public UserIdDto getAuthor() {
        return author;
    }

    public String getOperationId() {
        return operationId;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<AccountsSpaceKeyRequestDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    @JsonProperty("freeTier")
    public Optional<Boolean> getFreeTier() {
        return Optional.ofNullable(freeTier);
    }

    public String getAbcServiceSlug() {
        return abcServiceSlug;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccountAndProvideRequestDto that = (CreateAccountAndProvideRequestDto) o;
        return abcServiceId == that.abcServiceId &&
                Objects.equals(key, that.key) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(provisions, that.provisions) &&
                Objects.equals(knownProvisions, that.knownProvisions) &&
                Objects.equals(author, that.author) &&
                Objects.equals(operationId, that.operationId) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey) &&
                Objects.equals(freeTier, that.freeTier) &&
                Objects.equals(abcServiceSlug, that.abcServiceSlug);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, displayName, folderId, abcServiceId, provisions, knownProvisions, author,
                operationId, accountsSpaceKey, freeTier, abcServiceSlug);
    }

    @Override
    public String toString() {
        return "CreateAccountAndProvideRequestDto{" +
                "key='" + key + '\'' +
                ", displayName='" + displayName + '\'' +
                ", folderId='" + folderId + '\'' +
                ", abcServiceId=" + abcServiceId +
                ", provisions=" + provisions +
                ", knownProvisions=" + knownProvisions +
                ", author=" + author +
                ", operationId='" + operationId + '\'' +
                ", accountsSpaceKey=" + accountsSpaceKey +
                ", freeTier=" + freeTier +
                ", abcServiceSlug='" + abcServiceSlug + '\'' +
                '}';
    }

}
