package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Create account request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class CreateAccountRequestDto {

    private final String key;
    private final String displayName;
    private final String folderId;
    private final long abcServiceId;
    private final UserIdDto author;
    private final String operationId;
    private final AccountsSpaceKeyRequestDto accountsSpaceKey;
    private final Boolean freeTier;
    private final String abcServiceSlug;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public CreateAccountRequestDto(@JsonProperty("key") String key,
                                   @JsonProperty("displayName") String displayName,
                                   @JsonProperty("folderId") String folderId,
                                   @JsonProperty("abcServiceId") long abcServiceId,
                                   @JsonProperty("author") UserIdDto author,
                                   @JsonProperty("operationId") String operationId,
                                   @JsonProperty("accountsSpaceKey") AccountsSpaceKeyRequestDto accountsSpaceKey,
                                   @JsonProperty("freeTier") Boolean freeTier,
                                   @JsonProperty("abcServiceSlug") String abcServiceSlug
    ) {
        this.key = key;
        this.displayName = displayName;
        this.folderId = folderId;
        this.abcServiceId = abcServiceId;
        this.author = author;
        this.operationId = operationId;
        this.accountsSpaceKey = accountsSpaceKey;
        this.freeTier = freeTier;
        this.abcServiceSlug = abcServiceSlug;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public String getFolderId() {
        return folderId;
    }

    public long getAbcServiceId() {
        return abcServiceId;
    }

    public UserIdDto getAuthor() {
        return author;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getOperationId() {
        return Optional.ofNullable(operationId);
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<AccountsSpaceKeyRequestDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    public Optional<Boolean> getFreeTier() {
        return Optional.ofNullable(freeTier);
    }

    public String getAbcServiceSlug() {
        return abcServiceSlug;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccountRequestDto that = (CreateAccountRequestDto) o;
        return abcServiceId == that.abcServiceId &&
                Objects.equals(key, that.key) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(author, that.author) &&
                Objects.equals(operationId, that.operationId) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey) &&
                Objects.equals(freeTier, that.freeTier) &&
                Objects.equals(abcServiceSlug, that.abcServiceSlug);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, displayName, folderId, abcServiceId, author, operationId, accountsSpaceKey, freeTier,
                abcServiceSlug);
    }

    @Override
    public String toString() {
        return "CreateAccountRequestDto{" +
                "key='" + key + '\'' +
                ", displayName='" + displayName + '\'' +
                ", folderId='" + folderId + '\'' +
                ", abcServiceId=" + abcServiceId +
                ", author=" + author +
                ", operationId='" + operationId + '\'' +
                ", accountsSpaceKey=" + accountsSpaceKey +
                ", freeTier=" + freeTier +
                ", abcServiceSlug='" + abcServiceSlug + '\'' +
                '}';
    }

}
