package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Delete account request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeleteAccountRequestDto {

    private final String folderId;
    private final long abcServiceId;
    private final UserIdDto author;
    private final String operationId;
    private final AccountsSpaceKeyRequestDto accountsSpaceKey;

    @JsonCreator
    public DeleteAccountRequestDto(@JsonProperty("folderId") String folderId,
                                   @JsonProperty("abcServiceId") long abcServiceId,
                                   @JsonProperty("author") UserIdDto author,
                                   @JsonProperty("operationId") String operationId,
                                   @JsonProperty("accountsSpaceKey") AccountsSpaceKeyRequestDto accountsSpaceKey) {
        this.folderId = folderId;
        this.abcServiceId = abcServiceId;
        this.author = author;
        this.operationId = operationId;
        this.accountsSpaceKey = accountsSpaceKey;
    }

    public String getFolderId() {
        return folderId;
    }

    public long getAbcServiceId() {
        return abcServiceId;
    }

    public UserIdDto getAuthor() {
        return author;
    }

    public String getOperationId() {
        return operationId;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<AccountsSpaceKeyRequestDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeleteAccountRequestDto that = (DeleteAccountRequestDto) o;
        return abcServiceId == that.abcServiceId &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(author, that.author) &&
                Objects.equals(operationId, that.operationId) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, abcServiceId, author, operationId, accountsSpaceKey);
    }

    @Override
    public String toString() {
        return "DeleteAccountRequestDto{" +
                "folderId='" + folderId + '\'' +
                ", abcServiceId=" + abcServiceId +
                ", author=" + author +
                ", operationId='" + operationId + '\'' +
                ", accountsSpaceKey=" + accountsSpaceKey +
                '}';
    }

}
