package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Error messages.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class ErrorMessagesDto {

    private final String message;
    private final Map<String, String> fieldErrors;

    @JsonCreator
    public ErrorMessagesDto(@JsonProperty("message") String message,
                            @JsonProperty("fieldErrors") Map<String, String> fieldErrors) {
        this.message = message;
        this.fieldErrors = fieldErrors;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public Optional<Map<String, String>> getFieldErrors() {
        return Optional.ofNullable(fieldErrors);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ErrorMessagesDto that = (ErrorMessagesDto) o;
        return Objects.equals(message, that.message) &&
                Objects.equals(fieldErrors, that.fieldErrors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(message, fieldErrors);
    }

    @Override
    public String toString() {
        return "ErrorMessages{" +
                "message='" + message + '\'' +
                ", fieldErrors=" + fieldErrors +
                '}';
    }

}
