package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * List accounts request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class GetAccountRequestDto {

    private final boolean withProvisions;
    private final Boolean includeDeleted;
    private final String folderId;
    private final long abcServiceId;
    private final AccountsSpaceKeyRequestDto accountsSpaceKey;

    @JsonCreator
    public GetAccountRequestDto(@JsonProperty("withProvisions") boolean withProvisions,
                                @JsonProperty("includeDeleted") Boolean includeDeleted,
                                @JsonProperty("folderId") String folderId,
                                @JsonProperty("abcServiceId") long abcServiceId,
                                @JsonProperty("accountsSpaceKey") AccountsSpaceKeyRequestDto accountsSpaceKey) {
        this.withProvisions = withProvisions;
        this.includeDeleted = includeDeleted;
        this.folderId = folderId;
        this.abcServiceId = abcServiceId;
        this.accountsSpaceKey = accountsSpaceKey;
    }

    public boolean isWithProvisions() {
        return withProvisions;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<Boolean> getIncludeDeleted() {
        return Optional.ofNullable(includeDeleted);
    }

    public String getFolderId() {
        return folderId;
    }

    public long getAbcServiceId() {
        return abcServiceId;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<AccountsSpaceKeyRequestDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetAccountRequestDto that = (GetAccountRequestDto) o;
        return withProvisions == that.withProvisions &&
                abcServiceId == that.abcServiceId &&
                Objects.equals(includeDeleted, that.includeDeleted) &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(withProvisions, includeDeleted, folderId, abcServiceId, accountsSpaceKey);
    }

    @Override
    public String toString() {
        return "GetAccountRequestDto{" +
                "withProvisions=" + withProvisions +
                ", includeDeleted=" + includeDeleted +
                ", folderId='" + folderId + '\'' +
                ", abcServiceId=" + abcServiceId +
                ", accountsSpaceKey=" + accountsSpaceKey +
                '}';
    }

}
