package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Known account provisions.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class KnownAccountProvisionsDto {

    private final String accountId;
    private final List<KnownProvisionDto> knownProvisions;

    @JsonCreator
    public KnownAccountProvisionsDto(@JsonProperty("accountId") String accountId,
                                     @JsonProperty("knownProvisions") List<KnownProvisionDto> knownProvisions) {
        this.accountId = accountId;
        this.knownProvisions = knownProvisions;
    }

    public String getAccountId() {
        return accountId;
    }

    public List<KnownProvisionDto> getKnownProvisions() {
        return knownProvisions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        KnownAccountProvisionsDto that = (KnownAccountProvisionsDto) o;
        return Objects.equals(accountId, that.accountId) &&
                Objects.equals(knownProvisions, that.knownProvisions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, knownProvisions);
    }

    @Override
    public String toString() {
        return "KnownAccountProvisions{" +
                "accountId='" + accountId + '\'' +
                ", knownProvisions=" + knownProvisions +
                '}';
    }

}
