package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Provision request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class KnownProvisionDto {

    private final ResourceKeyRequestDto resourceKey;
    private final long providedAmount;
    private final String providedAmountUnitKey;

    @JsonCreator
    public KnownProvisionDto(@JsonProperty("resourceKey") ResourceKeyRequestDto resourceKey,
                             @JsonProperty("providedAmount") long providedAmount,
                             @JsonProperty("providedAmountUnitKey") String providedAmountUnitKey) {
        this.resourceKey = resourceKey;
        this.providedAmount = providedAmount;
        this.providedAmountUnitKey = providedAmountUnitKey;
    }

    public ResourceKeyRequestDto getResourceKey() {
        return resourceKey;
    }

    public long getProvidedAmount() {
        return providedAmount;
    }

    public String getProvidedAmountUnitKey() {
        return providedAmountUnitKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        KnownProvisionDto that = (KnownProvisionDto) o;
        return providedAmount == that.providedAmount &&
                Objects.equals(resourceKey, that.resourceKey) &&
                Objects.equals(providedAmountUnitKey, that.providedAmountUnitKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceKey, providedAmount, providedAmountUnitKey);
    }

    @Override
    public String toString() {
        return "KnownProvisionDto{" +
                "resourceKey=" + resourceKey +
                ", providedAmount=" + providedAmount +
                ", providedAmountUnitKey='" + providedAmountUnitKey + '\'' +
                '}';
    }

}
