package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Last update.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class LastUpdateDto {

    private final Long timestamp;
    private final UserIdDto author;
    private final String operationId;

    @JsonCreator
    public LastUpdateDto(@JsonProperty("timestamp") Long timestamp,
                         @JsonProperty("author") UserIdDto author,
                         @JsonProperty("operationId") String operationId) {
        this.timestamp = timestamp;
        this.author = author;
        this.operationId = operationId;
    }

    @Schema(description = "Timestamp in milliseconds from epoch of Unix", nullable = true)
    public Optional<Long> getTimestamp() {
        return Optional.ofNullable(timestamp);
    }

    public Optional<UserIdDto> getAuthor() {
        return Optional.ofNullable(author);
    }

    public Optional<String> getOperationId() {
        return Optional.ofNullable(operationId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LastUpdateDto that = (LastUpdateDto) o;
        return Objects.equals(timestamp, that.timestamp) &&
                Objects.equals(author, that.author) &&
                Objects.equals(operationId, that.operationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(timestamp, author, operationId);
    }

    @Override
    public String toString() {
        return "LastUpdate{" +
                "timestamp=" + timestamp +
                ", author=" + author +
                ", operationId='" + operationId + '\'' +
                '}';
    }

}
